/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.event;

import filenet.vw.api.VWAssociationDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWTextAnnotationDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.event.IVWMapChangedEventSource;
import filenet.vw.toolkit.design.property.event.IVWMapChangedListener;
import filenet.vw.toolkit.design.property.event.VWMapChangedEvent;
import java.util.Vector;
import javax.swing.event.EventListenerList;

public class VWMapChangeEventNotifier
implements IVWMapChangedEventSource {
    private EventListenerList m_mapChangedListeners = null;
    private VWMapNode[] m_changedMapNodes = null;
    private VWRouteDefinition[] m_changedRoutes = null;
    private VWTextAnnotationDefinition[] m_changedTextAnnotations = null;
    private VWAssociationDefinition[] m_changedAssociations = null;

    public VWMapNode[] getChangedSteps() {
        return this.m_changedMapNodes;
    }

    public VWRouteDefinition[] getChangedRoutes() {
        return this.m_changedRoutes;
    }

    public VWTextAnnotationDefinition[] getChangedTextAnnotations() {
        return this.m_changedTextAnnotations;
    }

    public VWAssociationDefinition[] getChangedAssociations() {
        return this.m_changedAssociations;
    }

    public void notifyItemsAdded(Object[] items) {
        this.organizeItemsAndNotify(items, 101);
    }

    public void notifyItemsRemoved(Object[] items) {
        this.organizeItemsAndNotify(items, 102);
    }

    public void notifyMapChange(int nEventId) {
        this.fireMapChangedNotification(new VWMapChangedEvent(this, nEventId));
    }

    public void notifyMapChange(VWMapChangedEvent event) {
        this.fireMapChangedNotification(event);
    }

    public void releaseReferences() {
        this.m_mapChangedListeners = null;
        this.m_changedMapNodes = null;
        this.m_changedRoutes = null;
        this.m_changedTextAnnotations = null;
        this.m_changedAssociations = null;
    }

    public void addMapChangedListener(IVWMapChangedListener listener) {
        if (this.m_mapChangedListeners == null) {
            this.m_mapChangedListeners = new EventListenerList();
        }
        this.removeMapChangedListener(listener);
        this.m_mapChangedListeners.add(IVWMapChangedListener.class, listener);
    }

    public void removeMapChangedListener(IVWMapChangedListener listener) {
        if (this.m_mapChangedListeners != null) {
            this.m_mapChangedListeners.remove(IVWMapChangedListener.class, listener);
        }
    }

    private void organizeItemsAndNotify(Object[] items, int nEventId) {
        if (items == null || items.length == 0) {
            return;
        }
        this.m_changedMapNodes = (VWMapNode[])this.getItemsOfClass(items, VWMapNode.class);
        this.m_changedRoutes = (VWRouteDefinition[])this.getItemsOfClass(items, VWRouteDefinition.class);
        this.m_changedTextAnnotations = (VWTextAnnotationDefinition[])this.getItemsOfClass(items, VWTextAnnotationDefinition.class);
        this.m_changedAssociations = (VWAssociationDefinition[])this.getItemsOfClass(items, VWAssociationDefinition.class);
        if (this.m_changedRoutes != null || this.m_changedMapNodes != null || this.m_changedTextAnnotations != null || this.m_changedAssociations != null) {
            this.fireMapChangedNotification(new VWMapChangedEvent(this, nEventId));
        }
    }

    private void fireMapChangedNotification(VWMapChangedEvent event) {
        try {
            if (event != null && this.m_mapChangedListeners != null && this.m_mapChangedListeners.getListenerCount() > 0) {
                Object[] listeners = this.m_mapChangedListeners.getListenerList();
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != IVWMapChangedListener.class) continue;
                    ((IVWMapChangedListener)listeners[i + 1]).mapChanged(event);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private Object[] getItemsOfClass(Object[] items, Class aClass) {
        Object[] itemArray = null;
        try {
            Vector<Object> retItems = new Vector<Object>();
            for (int index = 0; index < items.length; ++index) {
                if (items[index].getClass().getSuperclass() != aClass && items[index].getClass() != aClass) continue;
                retItems.addElement(items[index]);
            }
            if (retItems.size() == 0) {
                return null;
            }
            if (aClass == VWMapNode.class) {
                itemArray = new VWMapNode[retItems.size()];
            } else if (aClass == VWRouteDefinition.class) {
                itemArray = new VWRouteDefinition[retItems.size()];
            } else if (aClass == VWTextAnnotationDefinition.class) {
                itemArray = new VWTextAnnotationDefinition[retItems.size()];
            } else if (aClass == VWAssociationDefinition.class) {
                itemArray = new VWAssociationDefinition[retItems.size()];
            }
            if (itemArray != null) {
                retItems.copyInto(itemArray);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return itemArray;
    }
}

